/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.util.useradmin;

import filenet.vw.util.useradmin.CommitList;
import filenet.vw.util.useradmin.LogonPanel;
import filenet.vw.util.useradmin.MultiLogon;
import filenet.vw.util.useradmin.NotificationInput;
import filenet.vw.util.useradmin.UserList;
import filenet.vw.util.useradmin.UserMod;
import filenet.vw.util.useradmin.UserUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UserAdminPanel
extends JFrame {
    boolean LogonStatus = false;
    MultiLogon theLogon;
    LogonPanel theLogonPanel = new LogonPanel();
    UserList theUsers = new UserList();
    CommitList Committer = new CommitList();
    int RetrievedBatchSize = 250;
    JFileChooser jFileChooser1 = new JFileChooser();
    String currFileName = "thisData.csv";
    String InputName;
    String InputPassword;
    String theRmiUrl;
    Object[][] TransferArray;
    Object[][] StartArray = new Object[][]{{"uname", "mail@mailservice", "null", new Integer(9999)}};
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel ControlPanel = new JPanel();
    JPanel StatusPanel = new JPanel();
    JLabel Status = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField HostName = new JTextField();
    JTextField RouterName = new JTextField();
    JButton ConnectButton = new JButton();
    JButton CommitButton = new JButton();
    JButton ExitButton = new JButton();
    JTable EditTable = new JTable();
    JScrollPane EditScrollPane = new JScrollPane(this.EditTable);
    JTextField DialogText1 = new JTextField();
    JTextField DialogText2 = new JTextField();
    JDialog TwoEntryFields;
    Object[] choices = new Object[]{"Select Action", "Reload Users", "Export", "Refresh"};
    JComboBox ActionChoices = new JComboBox<Object>(this.choices);
    JTextArea EditBlank = new JTextArea();
    JButton FetchButton = new JButton();
    JLabel jLabel2 = new JLabel();

    public UserAdminPanel() {
        try {
            this.jbInit();
            this.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.Status.setFont(new Font("Dialog", 2, 9));
        this.Status.setText("Not Connected");
        this.StatusPanel.setLayout(this.gridLayout1);
        this.ControlPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(5);
        this.gridLayout2.setHgap(5);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setVgap(5);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setText("Server");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setText("Router");
        this.HostName.setText("localhost:32771");
        this.RouterName.setText("vwrouter");
        this.ConnectButton.setMaximumSize(new Dimension(50, 27));
        this.ConnectButton.setMinimumSize(new Dimension(50, 27));
        this.ConnectButton.setPreferredSize(new Dimension(50, 27));
        this.ConnectButton.setMargin(new Insets(2, 5, 2, 5));
        this.ConnectButton.setText("Connect");
        this.ConnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.ConnectButton_actionPerformed(e);
            }
        });
        this.CommitButton.setForeground(Color.red);
        this.CommitButton.setMaximumSize(new Dimension(50, 27));
        this.CommitButton.setMinimumSize(new Dimension(50, 27));
        this.CommitButton.setPreferredSize(new Dimension(50, 27));
        this.CommitButton.setMargin(new Insets(2, 5, 2, 5));
        this.CommitButton.setText("Commit");
        this.CommitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.CommitButton_actionPerformed(e);
            }
        });
        this.ExitButton.setMaximumSize(new Dimension(50, 27));
        this.ExitButton.setMinimumSize(new Dimension(50, 27));
        this.ExitButton.setPreferredSize(new Dimension(50, 27));
        this.ExitButton.setMargin(new Insets(2, 5, 2, 5));
        this.ExitButton.setText("Exit");
        this.ExitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.ExitButton_actionPerformed(e);
            }
        });
        this.setTitle("eProcess User Administration");
        this.setSize(600, 400);
        this.ActionChoices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.ActionChoices_actionPerformed(e);
            }
        });
        this.EditBlank.setBackground(new Color(212, 208, 200));
        this.EditBlank.setFont(new Font("Dialog", 2, 14));
        this.EditBlank.setForeground(Color.gray);
        this.EditBlank.setEditable(false);
        this.EditBlank.setMargin(new Insets(18, 12, 18, 36));
        this.EditBlank.setText("Logon to a valid server and router to retrieve the user database.\nMembers of SysAdminG, PWConfiguration or PWAdministration\nwill be able to edit all user accounts.\nNon-administrative members can edit their own account.");
        this.EditBlank.setLineWrap(true);
        this.EditBlank.setWrapStyleWord(true);
        this.ActionChoices.setBackground(new Color(212, 208, 200));
        this.FetchButton.setEnabled(false);
        this.FetchButton.setMaximumSize(new Dimension(50, 27));
        this.FetchButton.setMinimumSize(new Dimension(50, 27));
        this.FetchButton.setPreferredSize(new Dimension(50, 27));
        this.FetchButton.setMargin(new Insets(2, 5, 2, 5));
        this.FetchButton.setText("Next Batch");
        this.FetchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.FetchButton_actionPerformed(e);
            }
        });
        this.jLabel2.setFont(new Font("Dialog", 2, 9));
        this.jLabel2.setForeground(Color.gray);
        this.jLabel2.setText("Batch Feature Disabled");
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.EditScrollPane, "Edit User Properties");
        this.EditScrollPane.getViewport().add((Component)this.EditBlank, null);
        this.getContentPane().add((Component)this.ControlPanel, "North");
        this.getContentPane().add((Component)this.StatusPanel, "South");
        this.StatusPanel.add((Component)this.Status, null);
        this.ControlPanel.add((Component)this.jLabel1, null);
        this.ControlPanel.add((Component)this.jLabel3, null);
        this.ControlPanel.add((Component)this.FetchButton, null);
        this.ControlPanel.add((Component)this.ConnectButton, null);
        this.ControlPanel.add((Component)this.ExitButton, null);
        this.ControlPanel.add((Component)this.HostName, null);
        this.ControlPanel.add((Component)this.RouterName, null);
        this.ControlPanel.add((Component)this.jLabel2, null);
        this.ControlPanel.add((Component)this.CommitButton, null);
        this.ControlPanel.add((Component)this.ActionChoices, null);
    }

    void ConnectButton_actionPerformed(ActionEvent e) {
        if (!this.LogonStatus) {
            this.theRmiUrl = "rmi://" + this.HostName.getText() + "/" + this.RouterName.getText();
            this.theLogonPanel.setServerName(this.HostName.getText());
            this.theLogonPanel.setRouterName(this.RouterName.getText());
            this.theLogonPanel.show();
            this.theRmiUrl = "rmi://" + this.theLogonPanel.getServerName() + "/" + this.theLogonPanel.getRouterName();
            this.theLogon = new MultiLogon(this.theLogonPanel.getUserName(), this.theLogonPanel.getUserPassword(), this.theRmiUrl);
            JOptionPane.showMessageDialog(this, this.theLogon.getLogonStatus());
            if (this.theLogon.isConnected()) {
                this.LogonStatus = true;
                this.Status.setText(this.theLogon.getLogonStatus());
                this.theLogonPanel.setUserName("");
                this.theLogonPanel.setUserPassword("");
                this.showEditTable(this.theLogon);
            }
        } else {
            this.theLogon.Logoff();
            this.LogonStatus = false;
            this.Status.setText("Not Connected");
            this.removeEditTable();
        }
        this.ConnectButton.setText(this.LogonStatus ? "Disconnect" : "Connect");
    }

    void RefreshButton_actionPerformed(ActionEvent e) {
    }

    void CommitButton_actionPerformed(ActionEvent e) {
        if (this.Committer.getListSize() > 0) {
            this.Committer.showList();
        } else {
            JOptionPane.showMessageDialog(this, "No Changes to Commit", "List Empty", 0);
        }
        this.EditScrollPane.repaint();
    }

    void showTheDialog() {
        JButton DialogButton1 = new JButton();
        DialogButton1.setText("Go");
        DialogButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAdminPanel.this.DialogButton_actionPerformed(e);
            }
        });
        GridLayout DialogGrid = new GridLayout();
        this.TwoEntryFields = new JDialog();
        DialogGrid.setColumns(1);
        DialogGrid.setRows(3);
        this.TwoEntryFields.getContentPane().setLayout(DialogGrid);
        this.TwoEntryFields.setSize(200, 100);
        this.TwoEntryFields.setTitle("Logon");
        this.TwoEntryFields.setModal(true);
        this.TwoEntryFields.getContentPane().add(this.DialogText1);
        this.TwoEntryFields.getContentPane().add(this.DialogText2);
        this.TwoEntryFields.getContentPane().add((Component)DialogButton1, null);
        this.TwoEntryFields.show();
    }

    void DialogButton_actionPerformed(ActionEvent e) {
        this.TwoEntryFields.hide();
        this.InputName = this.DialogText1.getText();
        this.InputPassword = this.DialogText2.getText();
    }

    void ExitButton_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.ExitButton_actionPerformed(null);
        }
    }

    void ActionChoices_actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String ActionName = (String)cb.getSelectedItem();
        int ActionIndex = cb.getSelectedIndex();
        this.Status.setText("Returns: " + ActionIndex + ActionName);
        switch (ActionIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (this.LogonStatus) {
                    this.theUsers.getLogonDataBatch(this.theLogon, this.RetrievedBatchSize);
                    this.TransferArray = this.theUsers.getRetrievedData();
                    break;
                }
                JOptionPane.showMessageDialog(this, "Logon before trying to retrieve data.", "oops!", 2);
                break;
            }
            case 2: {
                this.exportFile();
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this, "Refresh both panes");
                break;
            }
            default: {
                this.Status.setText("This shouldn't display");
            }
        }
    }

    protected String objectToCsv(Object[][] ul) {
        String CsvText = "";
        for (int i = 0; i < ul.length; ++i) {
            CsvText = CsvText + ul[i][0] + ", " + (ul[i][1] == null ? "" : ul[i][1]) + ", " + (ul[i][2] == null ? "" : ul[i][2]) + ", " + ul[i][3] + "\n";
        }
        return CsvText;
    }

    boolean exportFile() {
        if (0 == this.jFileChooser1.showSaveDialog(this)) {
            try {
                this.currFileName = this.jFileChooser1.getSelectedFile().getPath();
                this.repaint();
                File file = new File(this.currFileName);
                FileWriter out = new FileWriter(file);
                String text = "User ID, eMail, Proxy, Notification Flags\n";
                out.write(text);
                out.close();
            }
            catch (IOException e) {
                this.Status.setText("Error saving " + this.currFileName);
            }
            return true;
        }
        this.repaint();
        return false;
    }

    public void setUpProxyColumn(TableColumn theProxyColumn) {
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.addItem("");
        for (int j = 0; j < this.theUsers.compactArray.length; ++j) {
            if (this.theUsers.compactArray[j][0].equals("SysAdmin") || this.theUsers.compactArray[j][0].equals("Operator") || this.theUsers.compactArray[j][0].equals("FieldService")) continue;
            comboBox.addItem(this.theUsers.compactArray[j][0]);
        }
        theProxyColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    private void setUpFlagEditor(JTable table) {
        JButton button = new JButton("|---|-|------|");
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final FlagEditor theFlagEditor = new FlagEditor(button);
        table.setDefaultEditor(Integer.class, theFlagEditor);
        final NotificationInput dialog = new NotificationInput();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer theFlagValue = (Integer)theFlagEditor.getCellEditorValue();
                dialog.prepareCheckBoxes(theFlagValue);
                dialog.setSize(500, 320);
                dialog.show();
                theFlagEditor.currentValue = dialog.getValue();
            }
        });
    }

    private void setUpFlagRenderer(JTable table) {
        table.setDefaultRenderer(Integer.class, new FlagRenderer(false));
    }

    void showEditTable(MultiLogon ml) {
        if (UserUtilities.isAdministrator(ml.session)) {
            this.theUsers.getLogonDataBatch(ml, this.RetrievedBatchSize);
        } else {
            String NotAdmin = "The logged on user is not an administrator.\n";
            NotAdmin = NotAdmin + "Non-administrators can only view and edit their\n";
            NotAdmin = NotAdmin + "own record in this application.";
            JOptionPane.showMessageDialog(this, NotAdmin);
            this.theUsers.getSoloData(ml);
        }
        this.TransferArray = this.theUsers.getRetrievedData();
        UserTableModel TheEditModel = new UserTableModel(this.Committer);
        TheEditModel.data = this.TransferArray;
        this.Committer.setData(TheEditModel.data);
        this.Committer.setUserList(this.theUsers, ml);
        this.EditTable.setModel(TheEditModel);
        this.EditScrollPane.getViewport().remove(this.EditBlank);
        this.initColumnSizes(this.EditTable, TheEditModel);
        this.setUpFlagEditor(this.EditTable);
        this.setUpFlagRenderer(this.EditTable);
        this.setUpProxyColumn(this.EditTable.getColumnModel().getColumn(2));
        this.EditScrollPane.getViewport().add(this.EditTable);
        this.EditScrollPane.repaint();
    }

    void removeEditTable() {
        this.EditScrollPane.getViewport().remove(this.EditTable);
        this.EditScrollPane.getViewport().add(this.EditBlank);
    }

    private void initColumnSizes(JTable table, UserTableModel model) {
        TableColumn column = null;
        Object comp = null;
        for (int i = 0; i < 4; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.sizeWidthToFit();
        }
    }

    public static void main(String[] args) {
        UserAdminPanel panel = new UserAdminPanel();
    }

    void FetchButton_actionPerformed(ActionEvent e) {
    }

    class FlagRenderer
    extends JLabel
    implements TableCellRenderer {
        private String FlagState;
        private int FlagInt;
        CommitList CommitIntegers;

        public FlagRenderer(boolean isBordered) {
            this.setOpaque(true);
        }

        void setCommitList(CommitList cl) {
            this.CommitIntegers = cl;
        }

        public Component getTableCellRendererComponent(JTable table, Object flags, boolean isSelected, boolean hasFocus, int row, int column) {
            this.FlagState = " |";
            this.setBackground(Color.lightGray);
            this.setFont(new Font("Monospaced", 3, 10));
            this.setForeground(Color.white);
            this.FlagInt = Integer.parseInt(flags.toString());
            this.FlagState = (this.FlagInt & 1) == 1 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 4) == 4 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 2) == 2 ? this.FlagState + "0|" : this.FlagState + "-|";
            this.FlagState = (this.FlagInt & 0x200) == 512 ? this.FlagState + "0|" : this.FlagState + "-|";
            this.FlagState = (this.FlagInt & 0x20) == 32 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 0x40) == 64 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 0x10) == 16 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 8) == 8 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 0x80) == 128 ? this.FlagState + "0" : this.FlagState + "-";
            this.FlagState = (this.FlagInt & 0x100) == 256 ? this.FlagState + "0|" : this.FlagState + "-|";
            this.setText(this.FlagState);
            return this;
        }
    }

    class FlagEditor
    extends DefaultCellEditor {
        Integer currentValue;

        public FlagEditor(JButton b) {
            super(new JCheckBox());
            this.currentValue = new Integer(0);
            this.editorComponent = b;
            this.setClickCountToStart(1);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FlagEditor.this.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(value.toString());
            this.currentValue = (Integer)value;
            return this.editorComponent;
        }
    }

    class UserTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"User Name", "eMail                 ", "Proxy", "Notification"};
        Object[][] data = new Object[][]{{"", "", "", new Integer(0)}};
        CommitList theCommitList;

        UserTableModel() {
            this.theCommitList = new CommitList(this.data);
        }

        UserTableModel(CommitList cl) {
            this.theCommitList = cl;
            this.theCommitList.setData(this.data);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public void setValueAt(Object value, int row, int col) {
            this.theCommitList.addMod(new UserMod((String)this.data[row][0], this.columnNames[col], col, row, this.data[row][col], value));
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

